capture log close
clear all
macro drop _all
cd "/Volumes/Mike2025/MC_CLIENTS/2025/AER 2025/Stata/Time Varying Models"
set more off
set maxiter 3000

**** SET PERIOD ***
local perd "long"      // can be "long" or "short"

log using "Output/log/SFA-Kumb90-AJTT-HN/anOpexReg24-SFA-Kumb90-AJTT-HN-`perd'", ///
	replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function - Time-Varying Models
			Using Generalised Kumbhakar 1990
Author:  Michael Cunningham & Alice Giovani 
File:    anOpexReg24-SFA-Kumb90-AJTT-HN.do
Initial Date:    29-Apr-2025
Revised Date:	 1-Sep-2025

--------------------------------------------------------------------------*/

* Period & dependent variable
if "`perd'" == "long" {
	local startyr 2006
	}
else if "`perd'" == "short" {
	local startyr 2012
}
local endyr   2023

* 
scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.219668445
scalar define propex_rebase_canada = 1.160126855  

* Read data
use "Input/DNSPopex24", clear
xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
qui tabulate dnsp, gen(d)
forvalues k = 1/13 {
	replace d`k' = 0 if d`k' == .
}

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

summarize d* jur*

* Sample selection
*-------------------------
drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------

* Adressing change of VIC's DNSP from calendar to financial year in 2021
generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

* Regression log variables
gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen lz1 = log(shareugc)

* mean correct output data
qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3
center yr, generate(t)

* TLG variables
gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly33 = (ly3^2)/2

*  Time Trend Variables
gen t_aus = cond(country == 1,t,0)
gen t_nz  = cond(country == 2,t,0)
gen t_ont = cond(country == 3,t,0)
forvalues i = 1/13 {
	gen t_dnsp`i' = cond(dnsp == `i',t,0)
}

* Labels
label variable ly1  "ln(Custnum)=x1" 
label variable ly2  "ln(CircLen)=x2" 
label variable ly3  "ln(RMDemand)=x3" 
label variable lz1  "ln(ShareUGC)" 
label variable ly11 "x1*x1/2" 
label variable ly12 "x1*x2" 
label variable ly13 "x1*x3" 
label variable ly22 "x2*x2/2" 
label variable ly23 "x2*x3" 
label variable ly33 "x3*x3/2"
label variable yr   "Year" 
label variable jur2 "New Zealand" 
label variable jur3 "Ontario" 

gen yearx = 0
replace yearx = year - 2004 if country == 3
replace yearx = year - 2005 if country < 3

qui tabulate yearx, generate(yr)

*local btvars t_aus t_nz t_ont
*local btnum = 4
local btvars t_dnsp1-t_dnsp13 t_nz t_ont
local btnum = 16

*General technical change index dummies
 
gen gtc1 = cond(yearx >= 1 & yearx <= 3,1,0)
gen gtc2 = cond(yearx >= 4 & yearx <= 6,1,0)
gen gtc3 = cond(yearx >= 7 & yearx <= 9,1,0)
gen gtc4 = cond(yearx >= 10 & yearx <= 12,1,0)
gen gtc5 = cond(yearx >= 13 & yearx <= 15,1,0)
gen gtc6 = cond(yearx >= 16 & yearx <= 18,1,0)

*Output Means by DNSPs 
egen ly1_mean = mean(ly1), by(eiid)
egen ly2_mean = mean(ly2), by(eiid)
egen ly3_mean = mean(ly3), by(eiid)

* Documentation

putdocx begin
putdocx paragraph, style(Title)
putdocx text ("SFA-SFA-Kumb90-AJTT-HN-`perd'" )

* Regression models
*---------------------- 

constraint 1 _b[mu:_cons] == 0

*===============================================
* SFACD  
* sfpanel (kumb90) 
*================================================
qui reg lvc ly1 ly2 ly3 lz1 yr jur2 jur3
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1

qui xtfrontier lvc ly1 ly2 ly3 lz1 yr jur2 jur3, cost from(b0, copy) ti ///
	diff constraints(1)
matrix b1 = e(b) 
matrix b1 = b1[1,1..8]
matrix list b1
*

matrix b2 = J(1, `btnum', 0.001)
matrix list b2

sfpanel lvc ly1 ly2 ly3 lz1 yr jur2 jur3, model(kumb90) cost ///
	bt(`btvars') svfrontier(b1) svbt(b2) technique(dfp) iterate(500)
estimates store SFACDk90

* STATS & TESTS	

predict eff, bc	
predict yhat1, xb
predict yhat2, u
gen yhat = yhat1 + yhat2		


gen v2CD = (lvc - yhat)^2
gen eh = lvc - yhat
estat ic
	
scalar k_sfacd = 26 		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFACD Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 lz1 yr jur2 jur3
linktest

* OUTPUT ELASTICITIES
	
predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)	
	
label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

putdocx paragraph, style(Subtitle)
putdocx text ("SFACD-Kumb90-AJTT-HN Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect	

* Decomposition

gen firstob = 0
replace firstob = 1 if eiid != eiid[_n-1]

forvalues k = 1/3 {
	gen swgt`k' = (((1 - elY)/elY)*ely`k' + ///
		((1 - elY[_n-1])/elY[_n-1])*ely`k'[_n-1])/2  if firstob == 0	
	gen ywgt`k' = (ely`k'/elY + ely`k'[_n-1]/elY[_n-1])/2  if firstob == 0
		
}		
gen sec   = swgt1*(ly1 - ly1[_n-1]) + swgt2*(ly2 - ly2[_n-1]) + ///
		    swgt3*(ly3 - ly3[_n-1])        if firstob == 0	
gen tc    = - _b[yr] * (yr - yr[_n-1])     if firstob == 0
gen oefc  = - _b[lz1] * (lz1 - lz1[_n-1])  if firstob == 0
gen tec  = - (yhat2 - yhat2[_n-1])        if firstob == 0
gen opfpc = sec + tc + oefc + tec          if firstob == 0

gen yc    = ywgt1*(ly1 - ly1[_n-1]) + ywgt2*(ly2 - ly2[_n-1]) + ///
		    ywgt3*(ly3 - ly3[_n-1])        if firstob == 0
gen costc = yhat - yhat[_n-1]              if firstob == 0			
gen opfpc2 = yc  - costc                   if firstob == 0
		
* EFFICIENCY SCORES	
	
export excel eiid year eff sec tc oefc tec opfpc opfpc2 yc costc using	///
	"Output/xlsx/SFA-Kumb90-AJTT-HN/SFA-Kumb90-AJTT-HN-Eff-`perd'.xlsx" if eiid < 2000, ///
	firstrow(var) replace sheet("SFACD") nolabel 

putdocx paragraph, style(Subtitle)
putdocx text ("SFACD-Kumb90-AJTT-HN Efficiency Scores")
table (country) (var), stat(mean eff ) nformat(%5.3f)
putdocx collect
table (dnsp) (var), stat(mean eff ) nformat(%5.3f)
putdocx collect

*Charts	
twoway (line eff year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line eff year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       

graph export "Output/chart/SFA-Kumb90-AJTT-HN/SFACD-Kumb90-AJTT-HN-Eff-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/SFA-Kumb90-AJTT-HN/SFACD-Kumb90-AJTT-HN-Eff-`perd'.png", ///
	width(8) height(5.6)

scatter eh yhat if country == 1, mcolor(blue) ///
    || scatter eh yhat if country == 2, mcolor(red) ///
    || scatter eh yhat if country == 3, mcolor(green) ///
    yline(0) ///
    ytitle("Residuals") ///
    xtitle("Fitted Values") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT")) ///
    yscale(range(-0.6,0.6)) ///
    ylabel(-0.6(0.2)0.6, grid)
	
graph export "Output/chart/SFA-Kumb90-AJTT-HN/SFACD-Kumb90-AJTT-HN-Res-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/SFA-Kumb90-AJTT-HN/SFACD-Kumb90-AJTT-HN-Res-`perd'.png", ///
	width(8) height(5.6)

estout SFACDk90 using ///
	"Output/xlsx/SFA-Kumb90-AJTT-HN/SFACD-Kumb90-AJTT-HN-Reg-`perd'.tsv", ///
	cells("b(fmt(4)) se(fmt(4)) t(fmt(4))") style(tab) label ///
	title("SFACD-Kumb90-AJTT-HN-`perd'") stats(N bic, fmt(3)) replace

drop yhat1 yhat2 yhat eff  ely1 ely2 ely3 elY lw_y1 up_y1 ///
	lw_y2 up_y2  lw_y3 up_y3 lw_Y up_Y eh ///
	   swgt1 swgt2 swgt3 ywgt1 ywgt2 ywgt3 opfpc sec tc oefc tec opfpc2 yc costc 
  
*===================================================
*  SFATLG 
*  sfpanel (kumb90) 
*===================================================

qui reg lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1
	
qui xtfrontier lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3, ///
	cost from(b0, copy) ti diff constraints(1)
matrix b1 = e(b) 
matrix b1 = b1[1,1..14]
matrix list b1

matrix b2 = J(1, `btnum', 0.001)
matrix list b2

sfpanel lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 ///
	jur3, model(kumb90) cost bt(`btvars') svfrontier(b1) svbt(b2) ///
	technique(dfp) iterate(500)
estimates store SFATLGk90

* STATS & TESTS		

predict eff, bc	
predict yhat1, xb
predict yhat2, u 
gen yhat = yhat1 + yhat2		


gen v2TLG = (lvc - yhat)^2
gen eh = lvc - yhat
estat ic
	
scalar k_sfacd = 32 		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFATLG Pseudo-adjusted R2 = " `psadjr2'

test ly11 ly12 ly13 ly22 ly23 ly33	

iqr eh
swilk eh
collin ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3
linktest

* OUTPUT ELASTICITIES
	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG-Kumb90-AJTT-HN-Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect	


* Decomposition

forvalues k = 1/3 {
	gen swgt`k' = (((1 - elY)/elY)*ely`k' + ///
		((1 - elY[_n-1])/elY[_n-1])*ely`k'[_n-1])/2  if firstob == 0	
	gen ywgt`k' = (ely`k'/elY + ely`k'[_n-1]/elY[_n-1])/2  if firstob == 0
		
}		
gen sec   = swgt1*(ly1 - ly1[_n-1]) + swgt2*(ly2 - ly2[_n-1]) + ///
		    swgt3*(ly3 - ly3[_n-1])        if firstob == 0	
gen tc    = - _b[yr] * (yr - yr[_n-1])     if firstob == 0
gen oefc  = - _b[lz1] * (lz1 - lz1[_n-1])  if firstob == 0
gen tec  = - (yhat2 - yhat2[_n-1])        if firstob == 0
gen opfpc = sec + tc + oefc + tec          if firstob == 0

gen yc    = ywgt1*(ly1 - ly1[_n-1]) + ywgt2*(ly2 - ly2[_n-1]) + ///
		    ywgt3*(ly3 - ly3[_n-1])        if firstob == 0
gen costc = yhat - yhat[_n-1]              if firstob == 0			
gen opfpc2 = yc  - costc                   if firstob == 0

	
* EFFICIENCY SCORES		
	
export excel eiid year eff sec tc oefc tec opfpc opfpc2 yc costc using ///
	"Output/xlsx/SFA-Kumb90-AJTT-HN/SFA-Kumb90-AJTT-HN-Eff-`perd'.xlsx" if eiid < 2000, ///
	firstrow(var) sheet("SFATLG", modify) nolabel 	
	
putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG-Kumb90-AJTT-HN Efficiency Scores")
table (dnsp) (var), stat(mean eff ) nformat(%5.3f)
putdocx collect
table (country) (var), stat(mean eff ) nformat(%5.3f)
putdocx collect

*Monotonicty	
display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,100,0)	
replace mon2 = cond(ely2 < 0,100,0)	
replace mon3 = cond(ely3 < 0,100,0)
replace montot = 100 if mon1 == 100 | mon2 == 100 | mon3 == 100

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG-Kumb90-AJTT-HN Monotonicity Violations")
table (country) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.1f)
putdocx collect
table (dnsp) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.1f)
putdocx collect

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
	using Output/xlsx/SFA-Kumb90-AJTT-HN/monotonicity-`perd'.xlsx, ///
	sheet("SFATLG", replace) firstrow(var) 	

	
*Charts	
twoway (line eff year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line eff year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       

graph export "Output/chart/SFA-Kumb90-AJTT-HN/SFATLG-Kumb90-AJTT-HN-Eff-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/SFA-Kumb90-AJTT-HN/SFATLG-Kumb90-AJTT-HN-Eff-`perd'.png", ///
	width(8) height(5.6)

scatter eh yhat if country == 1, mcolor(blue) ///
    || scatter eh yhat if country == 2, mcolor(red) ///
    || scatter eh yhat if country == 3, mcolor(green) ///
    yline(0) ///
    ytitle("Residuals") ///
    xtitle("Fitted Values") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT")) ///
    yscale(range(-0.6,0.6)) ///
    ylabel(-0.6(0.2)0.6, grid)
	
graph export "Output/chart/SFA-Kumb90-AJTT-HN/SFATLG-Kumb90-AJTT-HN-Res-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/SFA-Kumb90-AJTT-HN/SFATLG-Kumb90-AJTT-HN-Res-`perd'.png", ///
	width(8) height(5.6)

putdocx save "Output/docx/SFA-Kumb90-AJTT-HN/SFA-Kumb90-AJTT-HN-`perd'", replace

estout SFATLGk90 using ///
	"Output/xlsx/SFA-Kumb90-AJTT-HN/SFATLG-Kumb90-AJTT-HN-Reg-`perd'.tsv", ///
	cells("b(fmt(4)) se(fmt(4)) t(fmt(4))") style(tab) label ///
	title("SFATLG-Kumb90-AJTT-HN-`perd'") stats(N bic, fmt(3)) replace
	
* Variance of residuals by DNSP
	
sort eiid year
collapse (mean) v2CD v2TLG ly1_mean ly2_mean ly3_mean, by(eiid)

foreach i in CD TLG {
	forvalues j = 1/3 {
		regress v2`i' ly`j'_mean	
	}	
}



log close

